/*
 *  htk_cli.h
 *
 *  Created on: Feb 07, 2020
 *      Author: CrystalSu
 */

#ifndef HTK_CLI_H_
#define HTK_CLI_H_

#include "ht32.h"
#include "main.h"
#include "gpio.h"

/*Definition BC45 pins*/
/*SPI NCS pin to select BC45 Chip*/
#define NCS_CLR(PORTx, PINx)	GPIO_ClearOutBits(PORTx, PINx)
#define NCS_SET(PORTx, PINx)	GPIO_SetOutBits(PORTx, PINx)
/*RSTPD pin of BC45 which connected to MCU*/
#define RSTPD_CLR(PORTx, PINx)	GPIO_ClearOutBits(PORTx, PINx)
#define RSTPD_SET(PORTx, PINx)	GPIO_SetOutBits(PORTx, PINx)
/*IRQ pin of BC45 which connected to MCU*/
#define IRQ_PIN(PORTx, PINx)	GPIO_ReadInBit(PORTx, PINx)

StatusTypeDef SPI_TransmitReceive(HT_SPI_TypeDef *hspi, uint8_t *pTxData, uint8_t *pRxData, uint16_t Size, uint32_t Timeout);

void htk_SPI_writeSingleRegister(uint8_t address, uint8_t data);
void htk_SPI_readSingleRegister(uint8_t address, uint8_t *data);
void htk_SPI_writeMultiData(uint8_t address, uint8_t *data, uint16_t inputLen);
void htk_SPI_readMultiData(uint8_t address, uint8_t *data, uint16_t outputLen);
void htk_SPI_Init(HT_SPI_TypeDef *SPI, HT_GPIO_TypeDef *NCS_Port, uint16_t NCS_Pin);

#endif /* HTK_CLI_H_ */
